/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.client.renderers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_9331;
import rearth.belts.BlockContent;
import rearth.belts.BlockEntitiesContent;
import rearth.belts.ComponentContent;
import rearth.belts.blocks.ChuteBlockEntity;
import rearth.belts.items.BeltItem;
import rearth.belts.util.MathHelpers;
import rearth.belts.util.SplineUtil;

public class BeltOutlineRenderer {
    public static void renderPlannedBelt(class_638 world, class_4184 camera, class_4587 matrixStack, class_4597 consumer) {
        class_2350 endDir;
        class_2338 endBlockPos;
        boolean hasStart;
        if (world == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null || client.field_1765 == null || client.field_1765.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_1799 stack = player.method_6047();
        class_3965 blockHit = (class_3965)client.field_1765;
        if (!(stack.method_7909() instanceof BeltItem)) {
            return;
        }
        boolean bl = hasStart = stack.method_57826((class_9331)ComponentContent.BELT_START.get()) && stack.method_57826((class_9331)ComponentContent.BELT_DIR.get());
        if (!hasStart) {
            Optional targetedChuteCandidate;
            class_2680 startState;
            boolean couldBePlaced = false;
            class_2338 potentialStart = blockHit.method_17777().method_10081(blockHit.method_17780().method_10163());
            class_2350 startDir = blockHit.method_17780();
            if (blockHit.method_17780().method_10166().equals((Object)class_2350.class_2351.field_11052)) {
                startDir = player.method_5735().method_10153();
            }
            if ((startState = world.method_8320(potentialStart)).method_45474() || startState.method_26215()) {
                couldBePlaced = true;
            }
            if ((targetedChuteCandidate = world.method_35230(blockHit.method_17777(), (class_2591)BlockEntitiesContent.CHUTE_BLOCK.get())).isPresent()) {
                ChuteBlockEntity chuteEntity = (ChuteBlockEntity)((Object)targetedChuteCandidate.get());
                startDir = chuteEntity.getOwnFacing();
                potentialStart = blockHit.method_17777();
                couldBePlaced = true;
            }
            class_243 boxDirectionOffset = class_243.method_24954((class_2382)startDir.method_10163()).method_1021(0.1 + (double)((float)(world.method_8510() % 10L) / 20.0f));
            class_243 bowLower = potentialStart.method_46558().method_1020(class_243.method_24954((class_2382)startDir.method_10163()).method_1021((double)0.4f)).method_1023((double)0.1f, (double)0.1f, (double)0.1f);
            class_243 boxUpper = potentialStart.method_46558().method_1020(class_243.method_24954((class_2382)startDir.method_10163()).method_1021((double)0.4f)).method_1031((double)0.1f, (double)0.1f, (double)0.1f).method_1019(boxDirectionOffset);
            class_238 box = new class_238(bowLower, boxUpper);
            matrixStack.method_22903();
            class_243 cameraPos = camera.method_19326();
            matrixStack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
            class_761.method_22982((class_4587)matrixStack, (class_4588)consumer.getBuffer(class_1921.method_23594()), (class_238)box, (float)(couldBePlaced ? 0.1f : 1.0f), (float)(couldBePlaced ? 0.8f : 0.1f), (float)(couldBePlaced ? 0.7f : 0.0f), (float)0.9f);
            matrixStack.method_22909();
            return;
        }
        class_2338 startBlockPos = (class_2338)stack.method_57824((class_9331)ComponentContent.BELT_START.get());
        class_2350 startFacing = (class_2350)stack.method_57824((class_9331)ComponentContent.BELT_DIR.get());
        if (startBlockPos == null || startBlockPos.equals((Object)class_2338.field_10980) || startFacing == null) {
            return;
        }
        class_243 startPos = startBlockPos.method_46558();
        class_2382 startDir = startFacing.method_10163();
        List<class_3545<class_2338, class_2350>> midPoints = BeltItem.getStoredMidpoints(stack, (class_1937)world);
        Optional endChuteCandidate = world.method_35230(blockHit.method_17777(), (class_2591)BlockEntitiesContent.CHUTE_BLOCK.get());
        if (endChuteCandidate.isPresent()) {
            ChuteBlockEntity endChute = (ChuteBlockEntity)((Object)endChuteCandidate.get());
            endBlockPos = blockHit.method_17777();
            endDir = endChute.getOwnFacing().method_10153();
        } else if (world.method_8320(blockHit.method_17777()).method_26204().equals(BlockContent.CONVEYOR_SUPPORT_BLOCK.get())) {
            class_2338 conveyorPos = blockHit.method_17777();
            class_2350 conveyorFacing = (class_2350)world.method_8320(blockHit.method_17777()).method_11654((class_2769)class_2383.field_11177);
            class_2382 reversedConveyorFacing = conveyorFacing.method_10163().method_35862(-1);
            class_2338 lastEnd = midPoints.isEmpty() ? startBlockPos : (class_2338)midPoints.getLast().method_15442();
            double distA = conveyorPos.method_10081(conveyorFacing.method_10163()).method_10262((class_2382)lastEnd);
            double distB = conveyorPos.method_10081(reversedConveyorFacing).method_10262((class_2382)lastEnd);
            endDir = distB < distA ? conveyorFacing : conveyorFacing.method_10153();
            endBlockPos = conveyorPos;
        } else {
            endBlockPos = blockHit.method_17777().method_10081(blockHit.method_17780().method_10163());
            endDir = blockHit.method_17780().method_10153();
            if (endDir.method_10166().method_10178()) {
                endDir = player.method_5735().method_10153();
            }
        }
        class_243 visualEndPos = endBlockPos.method_46558();
        class_2382 visualEndDir = endDir.method_10163();
        matrixStack.method_22903();
        class_243 cameraPos = camera.method_19326();
        matrixStack.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
        List<class_243> linePoints = BeltOutlineRenderer.getPositionsAlongLine(startPos, visualEndPos, startDir, visualEndDir, midPoints);
        class_243 lastForward = class_243.method_24954((class_2382)startDir).method_1029();
        class_243 lastCenter = class_243.field_1353;
        if (!linePoints.isEmpty()) {
            lastCenter = linePoints.getFirst();
        }
        for (class_243 center : linePoints) {
            float lineRadius = 0.05f;
            class_243 newForward = center.method_1020(lastCenter).method_1029();
            if (center.equals((Object)lastCenter)) {
                newForward = lastForward;
            }
            double curveFactor = newForward.method_1022(lastForward);
            class_243 color = new class_243(1.0, 1.0, 1.0);
            if (curveFactor > 0.25) {
                color = new class_243(1.0, (double)0.6f, (double)0.2f);
            }
            if (curveFactor > (double)0.43f) {
                color = new class_243(1.0, 0.0, 0.0);
            }
            lastCenter = center;
            lastForward = MathHelpers.lerp(lastForward, newForward, 0.3f);
            class_761.method_22980((class_4587)matrixStack, (class_4588)consumer.getBuffer(class_1921.method_23594()), (double)(center.field_1352 - (double)lineRadius), (double)(center.field_1351 - (double)lineRadius), (double)(center.field_1350 - (double)lineRadius), (double)(center.field_1352 + (double)lineRadius), (double)(center.field_1351 + (double)lineRadius), (double)(center.field_1350 + (double)lineRadius), (float)((float)color.field_1352), (float)((float)color.field_1351), (float)((float)color.field_1350), (float)0.8f);
        }
        matrixStack.method_22909();
    }

    private static List<class_243> getPositionsAlongLine(class_243 from, class_243 to, class_2382 startDir, class_2382 endDir, List<class_3545<class_2338, class_2350>> midpoints) {
        float stepSize = 0.1f;
        ArrayList<class_243> result = new ArrayList<class_243>();
        List<class_3545<class_243, class_243>> transformedMidPoints = midpoints.stream().map(elem -> new class_3545((Object)((class_2338)elem.method_15442()).method_46558(), (Object)class_243.method_24954((class_2382)((class_2350)elem.method_15441()).method_10163()))).toList();
        List<class_3545<class_243, class_243>> segmentPoints = SplineUtil.getPointPairs(from, class_243.method_24954((class_2382)startDir), to, class_243.method_24954((class_2382)endDir), transformedMidPoints);
        double dist = SplineUtil.getTotalLength(segmentPoints);
        float i = 0.0f;
        while ((double)i < dist) {
            double progress = (double)i / dist;
            class_243 center = SplineUtil.getPositionOnSpline(from, class_243.method_24954((class_2382)startDir), to, class_243.method_24954((class_2382)endDir), midpoints, progress);
            result.add(center);
            i += stepSize;
        }
        return result;
    }
}

